﻿// Repurposed out-of-the-box SharePoint JS for the Office 365 Suite Bar Drop Down Menus

function CustomSuiteBarMenu_Hide (menuDivID, popupOwnerID) {
    var menuDiv = document.getElementById(menuDivID);

    if (menuDiv)
    {
        menuDiv.style.display = "none";
        menuDiv.style.top = "-10000px";
		
        var popupOwner = document.getElementById(popupOwnerID);        
        RemoveCssClassFromElement(popupOwner, "ms-core-suiteLink-active");
    }
};

function CustomSuiteBarMenu_GetRectangle (elem) {
    var rWin = elem.getBoundingClientRect();
    var xOff = Boolean(window.pageXOffset) ? window.pageXOffset : document.documentElement.scrollLeft;
    var yOff = Boolean(window.pageYOffset) ? window.pageYOffset : document.documentElement.scrollTop;
    var rDoc = {};

    rDoc.left = rWin.left + xOff;
    rDoc.right = rWin.right + xOff;
    rDoc.top = rWin.top + yOff;
    rDoc.bottom = rWin.bottom + yOff;
    return rDoc;
};
		
function CustomSuiteBarMenu_ShowMenu(popupOwnerID, menuDivID, navBarID) {
    var IsRtl = window.document.documentElement.getAttribute("dir") == "rtl";
    var menuDiv = document.getElementById(menuDivID);
    var popupOwner = document.getElementById(popupOwnerID);
    var navBar = document.getElementById(navBarID);
	
    CustomSuiteBarMenu_Hide(menuDivID, popupOwnerID);
	
    AddCssClassToElement(popupOwner, "ms-core-suiteLink-active");
	
    var currentMenuOwnerBoundingRect = CustomSuiteBarMenu_GetRectangle(popupOwner);
    var navBarBoundingRect = CustomSuiteBarMenu_GetRectangle(navBar);

    menuDiv.style.display = "inline-block";
    var menuLeft;
    var menuWidth = menuDiv.offsetWidth;
	
    if (IsRtl) {
        menuLeft = currentMenuOwnerBoundingRect.right - menuWidth;
    }
    else {
        menuLeft = currentMenuOwnerBoundingRect.left;
    }
	
    var winWidth = document.documentElement.clientWidth;
    var winLeft = Boolean(window.pageXOffset) ? window.pageXOffset : document.documentElement.scrollLeft;
    var winRight = winLeft + winWidth;

    if (menuLeft < winLeft) {
        menuLeft = winLeft;
    }
    else if (menuLeft + menuWidth > winRight) {
        menuLeft = winRight - menuWidth;
    }
    menuDiv.style.left = String(Math.max(winLeft, menuLeft)) + "px";
    menuDiv.style.top = String(navBarBoundingRect.bottom) + "px";
};